
// --- Edit Attendance Logic ---
const $editAttModal = $('#hrm-edit-attendance-modal');
const $editAttForm = $('#hrm-edit-attendance-form');

$(document).on('click', '.hrm-edit-attendance-btn', function (e) {
    e.preventDefault();
    const btn = $(this);

    $('#edit_record_id').val(btn.data('id'));
    $('#edit_date').val(btn.data('date'));
    $('#edit_check_in').val(btn.data('in'));
    $('#edit_check_out').val(btn.data('out'));
    $('#edit_status').val(btn.data('status'));

    $editAttModal.fadeIn(200);
});

// Close logic
$editAttModal.on('click', function (e) {
    if ($(e.target).is($editAttModal) || $(e.target).hasClass('hrm-modal-close')) {
        $editAttModal.fadeOut(200);
    }
});

$editAttForm.on('submit', function (e) {
    e.preventDefault();
    const $submitBtn = $(this).find('button[type="submit"]');
    const originalText = $submitBtn.text();
    $submitBtn.text('Saving...').prop('disabled', true);

    const formData = {
        action: 'hrm_edit_attendance',
        nonce: hrm_ajax.nonce, // Ensure hrm_ajax is available in admin too? 
        // Wait, hrm_ajax is localized in frontend assets. Admin assets need it too.
        // Check hrm-setup.php if admin assets have hrm_ajax.
        record_id: $('#edit_record_id').val(),
        date: $('#edit_date').val(),
        check_in: $('#edit_check_in').val(),
        check_out: $('#edit_check_out').val(),
        status: $('#edit_status').val()
    };

    // Note: Admin might not have 'hrm_ajax' object if not localized.
    // Usually admin uses 'ajaxurl' global.
    // Nonce? I need to localize nonce for admin.
    // Assuming 'hrm_ajax_nonce' is what I need.
    // I'll check hrm-setup.php enqueue_admin_assets.

    // For now assuming ajaxurl exists.
    formData.nonce = hrm_admin_params.nonce; // I will ensure this exists.

    $.post(ajaxurl, formData, function (response) {
        if (response.success) {
            location.reload();
        } else {
            alert('Error: ' + (response.data || 'Unknown error'));
            $submitBtn.text(originalText).prop('disabled', false);
        }
    }).fail(function () {
        alert('Server Error');
        $submitBtn.text(originalText).prop('disabled', false);
    });
});
